<?php
include ("db.php");

// Start the session
session_start();

// Set content type to JSON for API response
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Origin: https://hapitest.xyz/hapi%20bilzs%20sts/admin");
header("Access-Control-Allow-Credentials: true");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Handle login request
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input']);
        exit();
    }

    $username = isset($data['username']) ? $data['username'] : '';
    $password = isset($data['password']) ? $data['password'] : '';
    $rememberMe = isset($data['remember_me']) && $data['remember_me'] === true;

    if (empty($username) || empty($password)) {
        echo json_encode(['status' => 'error', 'message' => 'Username or password missing']);
        exit();
    }

    // Check the database for user
    $sql = "SELECT * FROM user_login WHERE Delete_status = 0 AND Username = '$username' LIMIT 1";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();

        // Verify password
        if (password_verify($password, $user['Password'])) {
            // Set session variables
            $_SESSION['user_id'] = $user['Id'];
            $_SESSION['username'] = $user['Username'];

            // Handle "Remember Me" functionality
            if ($rememberMe) {
                $token = bin2hex(random_bytes(16));
                $expiry = time() + (30 * 24 * 60 * 60); // 30 days expiry
                $userId = $user['Id'];
                $storeTokenSql = "UPDATE user_login SET Remember_token = '$token' WHERE Id = '$userId'";
                
                if ($conn->query($storeTokenSql)) {
                    setcookie("remember_me", $token, $expiry, "/", "", false, true); // Set cookie
                }
            }

            // Log sign-in time
            $user_id = $user['Id'];
            $name = $user['Username'];
            $in_date = date('Y-m-d');
            $insertSql = "INSERT INTO sign_in (User_id, Name, In_Time, In_Date, Delete_status) 
                          VALUES ('$user_id', '$name', NOW(), '$in_date', 0)";
            $conn->query($insertSql);

            // Return successful response
            echo json_encode([
                'status' => 'success',
                'message' => 'Login successful',
                'data' => [
                    'user_id' => $user['Id'],
                    'username' => $user['Username'],
                    'email' => $user['Email']
                ]
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid username or password']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid username or password']);
    }
} elseif ($_SERVER['REQUEST_METHOD'] == 'GET') {
    // Handle "Remember Me" functionality on GET request
    if (isset($_COOKIE['remember_me'])) {
        $token = $_COOKIE['remember_me'];
        $sql = "SELECT * FROM user_login WHERE Remember_token = '$token' AND Delete_status = 0 LIMIT 1";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
            $_SESSION['user_id'] = $user['Id'];
            $_SESSION['username'] = $user['Username'];

            // Return successful response
            echo json_encode([
                'status' => 'success',
                'message' => 'User remembered',
                'data' => [
                    'user_id' => $user['Id'],
                    'username' => $user['Username'],
                    'email' => $user['Email']
                ]
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid remember token']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No remember token found']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Only POST and GET methods are allowed']);
}

$conn->close();
?>